/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.AbstractImmutableCollection;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableListImpl;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableMapImpl;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.fluent.collections.UnmodifiableSet;
import com.floragunn.fluent.collections.views.IterableView;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

class ImmutableSetImpl {
    private static final Set<Collector.Characteristics> COLLECTOR_CHARACTERISTICS = UnmodifiableSet.of(EnumSet.of(Collector.Characteristics.UNORDERED));

    ImmutableSetImpl() {
    }

    static <E> ImmutableSet<E> empty() {
        EmptySet<?> result = EmptySet.INSTANCE;
        return result;
    }

    static <E> ImmutableSet<E> of(E e) {
        return new OneElementSet<E>(e);
    }

    static <E> ImmutableSet<E> of(E e1, E e2) {
        if (Objects.equals(e1, e2)) {
            return new OneElementSet<E>(e1);
        }
        return new TwoElementSet<E>(e1, e2);
    }

    static <E> ImmutableSet<E> ofNonNull(E e1, E e2) {
        if (e1 != null) {
            if (e2 != null) {
                return ImmutableSetImpl.of(e1, e2);
            }
            return ImmutableSetImpl.of(e1);
        }
        if (e2 != null) {
            return ImmutableSetImpl.of(e2);
        }
        return ImmutableSetImpl.empty();
    }

    @SafeVarargs
    static <E> ImmutableSet<E> of(E e, E ... more) {
        if (e == null) {
            return ImmutableSetImpl.ofArray(more);
        }
        if (more == null || more.length == 0) {
            return new OneElementSet<E>(e);
        }
        return new ImmutableSet.Builder<E>(Arrays.asList(more)).with(e).build();
    }

    @SafeVarargs
    static <E> ImmutableSet<E> ofArray(E ... more) {
        if (more == null || more.length == 0) {
            return ImmutableSetImpl.empty();
        }
        if (more.length == 1 || more.length == 2 && Objects.equals(more[0], more[1])) {
            return new OneElementSet<E>(more[0]);
        }
        if (more.length == 2) {
            return new TwoElementSet<E>(more[0], more[1]);
        }
        return new ImmutableSet.Builder<E>(Arrays.asList(more)).build();
    }

    static <E> ImmutableSet<E> of(Collection<E> collection) {
        if (collection == null || collection.size() == 0) {
            return ImmutableSetImpl.empty();
        }
        if (collection instanceof ImmutableSet) {
            return (ImmutableSet)collection;
        }
        if (collection.size() == 1) {
            return new OneElementSet<E>(collection.iterator().next());
        }
        if (collection.size() == 2) {
            E e2;
            Iterator<E> iter = collection.iterator();
            E e1 = iter.next();
            if (Objects.equals(e1, e2 = iter.next())) {
                return new OneElementSet<E>(e1);
            }
            return new TwoElementSet<E>(e1, e2);
        }
        return new ImmutableSet.Builder<E>(collection).build();
    }

    static <E> ImmutableSet<E> of(Iterable<E> iterable) {
        ImmutableSet.Builder<E> builder = new ImmutableSet.Builder<E>();
        for (E e : iterable) {
            builder.add(e);
        }
        return builder.build();
    }

    static <E> ImmutableSet<E> of(Set<E> set, E other) {
        if (set == null || set.size() == 0) {
            return new OneElementSet<E>(other);
        }
        if (set.size() == 1) {
            if (other.equals(set.iterator().next())) {
                if (set instanceof ImmutableSet) {
                    return (ImmutableSet)set;
                }
                return new OneElementSet<E>(other);
            }
            return new TwoElementSet<E>(set.iterator().next(), other);
        }
        if (set.contains(other)) {
            if (set instanceof ImmutableSet) {
                return (ImmutableSet)set;
            }
            return new ImmutableSet.Builder<E>(set).build();
        }
        return new ImmutableSet.Builder<E>(set).with(other).build();
    }

    static <E> ImmutableSet<E> of(Set<E> set) {
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        if (set == null || set.size() == 0) {
            return ImmutableSetImpl.empty();
        }
        if (set.size() == 1) {
            return new OneElementSet<E>(set.iterator().next());
        }
        if (set.size() == 2) {
            Iterator<E> iter = set.iterator();
            return new TwoElementSet<E>(iter.next(), iter.next());
        }
        if (set.size() <= 4) {
            return new ArrayBackedSet<E>(set);
        }
        return new ImmutableSet.Builder<E>(set).build();
    }

    static <E> ImmutableSet<E> flattenDeep(Collection<?> collection, Function<Object, E> mappingFunction) {
        if (collection.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (collection.size() == 1) {
            Object value;
            Object object = value = collection instanceof List ? ((List)collection).get(0) : collection.iterator().next();
            if (value == null) {
                return ImmutableSet.empty();
            }
            if (!(value instanceof Collection)) {
                return new OneElementSet<E>(mappingFunction.apply(value));
            }
        }
        ImmutableSet.Builder result = new ImmutableSet.Builder(collection.size());
        ImmutableSetImpl.flatten(collection, result, mappingFunction);
        return result.build();
    }

    static <E> void flatten(Collection<?> collection, ImmutableSet.Builder<E> result, Function<Object, E> mappingFunction) {
        for (Object o : collection) {
            E e;
            if (o instanceof Collection) {
                ImmutableSetImpl.flatten((Collection)o, result, mappingFunction);
                continue;
            }
            if (o == null || (e = mappingFunction.apply(o)) == null) continue;
            result.add(e);
        }
    }

    static <C, E> ImmutableSet<E> map(Collection<C> collection, Function<C, E> mappingFunction) {
        ImmutableSet.Builder<E> builder = new ImmutableSet.Builder<E>(collection.size());
        for (C c : collection) {
            E value = mappingFunction.apply(c);
            if (value == null) continue;
            builder.with(value);
        }
        return builder.build();
    }

    static <E> Collector<E, ?, ImmutableSet<E>> collector() {
        return new Collector<E, ImmutableSet.Builder<E>, ImmutableSet<E>>(){

            @Override
            public Supplier<ImmutableSet.Builder<E>> supplier() {
                return ImmutableSet.Builder::new;
            }

            @Override
            public BiConsumer<ImmutableSet.Builder<E>, E> accumulator() {
                return ImmutableSet.Builder::add;
            }

            @Override
            public BinaryOperator<ImmutableSet.Builder<E>> combiner() {
                return (builder1, builder2) -> {
                    builder1.addAll(builder2.build());
                    return builder1;
                };
            }

            @Override
            public Function<ImmutableSet.Builder<E>, ImmutableSet<E>> finisher() {
                return ImmutableSet.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return COLLECTOR_CHARACTERISTICS;
            }
        };
    }

    static class WithSet<E>
    extends AbstractImmutableSet<E> {
        private final ImmutableSet<E> base;
        private final E additional;
        private final int size;

        WithSet(ImmutableSet<E> base, E additional) {
            this.base = base;
            this.additional = additional;
            this.size = base.size() + 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return Objects.equals(o, this.additional) || this.base.contains(o);
        }

        @Override
        public E any() {
            return this.additional;
        }

        @Override
        public E only() {
            if (this.size == 1) {
                return this.additional;
            }
            throw new IllegalStateException();
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                private Iterator<E> delegate;
                private boolean hasAdditional;
                {
                    this.delegate = base.iterator();
                    this.hasAdditional = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.delegate.hasNext()) {
                        return true;
                    }
                    return this.hasAdditional;
                }

                @Override
                public E next() {
                    if (this.delegate.hasNext()) {
                        return this.delegate.next();
                    }
                    if (this.hasAdditional) {
                        this.hasAdditional = false;
                        return additional;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int hashCode() {
            return this.base.hashCode() + this.additional.hashCode();
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            ImmutableSet<E> baseResult = this.base.matching(predicate);
            if (predicate.test(this.additional)) {
                return baseResult.with(this.additional);
            }
            return baseResult;
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            ImmutableSet<E> baseResult = this.base.intersection(other);
            if (other.contains(this.additional)) {
                return baseResult.with(this.additional);
            }
            return baseResult;
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.isEmpty()) {
                return this;
            }
            return this.matching(e -> !other.contains(e));
        }

        @Override
        public String toShortString() {
            int i = 0;
            StringBuilder result = new StringBuilder("[");
            for (Object e : this) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(e);
                if (++i < 7 || i >= this.size - 1) continue;
                result.append(", ").append(this.size - i).append(" more...");
                break;
            }
            result.append("]");
            return result.toString();
        }

        @Override
        public ImmutableList<E> toList() {
            return this.base.toList().with(this.additional);
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            return this.base.toMap(mappingFunction).with(this.additional, mappingFunction.apply(this.additional));
        }
    }

    static class EmptySet<E>
    extends AbstractImmutableSet<E> {
        static EmptySet<?> INSTANCE = new EmptySet();

        EmptySet() {
        }

        @Override
        public E any() {
            throw new IllegalStateException();
        }

        @Override
        public E only() {
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.empty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            return this;
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            return this;
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            return this;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public String toShortString() {
            return "[]";
        }

        @Override
        public Iterable<E> iterateMatching(Predicate<E> predicate) {
            return this;
        }

        @Override
        public ImmutableList<E> toList() {
            return ImmutableList.empty();
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            return ImmutableMap.empty();
        }
    }

    static class SetBackedSet<E>
    extends AbstractImmutableSet<E> {
        private final Set<E> elements;

        SetBackedSet(Set<E> elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.elements.contains(o);
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.of(this.elements.iterator());
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.elements.toArray(a);
        }

        @Override
        public Object[] toArray() {
            return this.elements.toArray();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.elements.containsAll(c);
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            HashSet<E> newSet = new HashSet<E>(this.elements.size());
            for (E e : this.elements) {
                if (!predicate.test(e)) continue;
                newSet.add(e);
            }
            return ImmutableSetImpl.of(newSet);
        }

        @Override
        public Iterable<E> iterateMatching(Predicate<E> predicate) {
            return IterableView.filter(this.elements, predicate);
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            if (other.isEmpty()) {
                return ImmutableSetImpl.empty();
            }
            if (other instanceof ImmutableSet && other.size() < this.size()) {
                return ((ImmutableSet)other).intersection(this);
            }
            HashSet<E> newSet = new HashSet<E>(this.elements);
            newSet.retainAll(other);
            return ImmutableSetImpl.of(newSet);
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.isEmpty()) {
                return this;
            }
            return this.matching(e -> !other.contains(e));
        }

        @Override
        public String toShortString() {
            int i = 0;
            StringBuilder result = new StringBuilder("[");
            for (E e : this.elements) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(e);
                if (++i < 7 || i >= this.elements.size() - 1) continue;
                result.append(", ").append(this.elements.size() - i).append(" more...");
                break;
            }
            result.append("]");
            return result.toString();
        }

        @Override
        public ImmutableList<E> toList() {
            return ImmutableList.of(this);
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            HashMap<E, V> result = new HashMap<E, V>();
            for (E e : this.elements) {
                result.put(e, mappingFunction.apply(e));
            }
            return new ImmutableMapImpl.MapBackedMap(result);
        }

        static class Builder<E>
        extends InternalBuilder<E> {
            private HashSet<E> delegate;

            Builder(int expectedCapacity) {
                this.delegate = new HashSet(expectedCapacity);
            }

            Builder(Collection<E> set) {
                this.delegate = new HashSet<E>(set);
            }

            @Override
            public Builder<E> with(E e) {
                this.delegate.add(e);
                return this;
            }

            @Override
            ImmutableSet<E> build() {
                return new SetBackedSet<E>(this.delegate);
            }

            @Override
            InternalBuilder<E> with(Collection<E> e) {
                this.delegate.addAll(e);
                return this;
            }

            @Override
            int size() {
                return this.delegate.size();
            }

            @Override
            boolean remove(E e) {
                return this.delegate.remove(e);
            }

            @Override
            boolean contains(E e) {
                return this.delegate.contains(e);
            }

            @Override
            boolean containsAny(Set<E> set) {
                for (E e : set) {
                    if (!this.delegate.contains(e)) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean containsAll(Set<E> set) {
                return this.delegate.containsAll(set);
            }

            @Override
            public Iterator<E> iterator() {
                return this.delegate.iterator();
            }

            @Override
            E any() {
                return this.delegate.iterator().next();
            }

            @Override
            void clear() {
                this.delegate.clear();
            }

            @Override
            public String toString() {
                return this.delegate.toString();
            }

            @Override
            String toDebugString() {
                return this.delegate.toString();
            }
        }
    }

    static class HashArrayBackedSet<E>
    extends AbstractImmutableSet<E> {
        private static final int COLLISION_HEAD_ROOM = 4;
        private static final int NO_SPACE = Integer.MAX_VALUE;
        final int tableSize;
        final int size;
        private final E[] table1;
        private final E[] table2;
        private E[] flat;

        HashArrayBackedSet(int tableSize, int size, E[] table1, E[] table2) {
            this.tableSize = tableSize;
            this.size = size;
            this.table1 = table1;
            this.table2 = table2;
        }

        HashArrayBackedSet(int tableSize, int size, E[] table1, E[] table2, E[] flat) {
            this.tableSize = tableSize;
            this.size = size;
            this.table1 = table1;
            this.table2 = table2;
            this.flat = flat;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.contains(o, this.hashPosition(o));
        }

        boolean contains(Object o, int pos) {
            if (o.equals(this.table1[pos])) {
                return true;
            }
            return this.table2 != null && this.checkTable2(o, pos) < 0;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            if (this.isEmpty()) {
                return UnmodifiableIterator.empty();
            }
            return new UnmodifiableIterator<E>(){
                private E[] table;
                private int i;
                {
                    this.table = table1;
                    this.i = HashArrayBackedSet.findIndexOfNextNonNull(table1, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.table != null;
                }

                @Override
                public E next() {
                    if (this.table == null || this.i == -1) {
                        throw new NoSuchElementException();
                    }
                    Object element = this.table[this.i];
                    this.i = HashArrayBackedSet.findIndexOfNextNonNull(this.table, this.i + 1);
                    if (this.i == -1) {
                        if (this.table == table1) {
                            this.table = table2;
                            if (this.table != null) {
                                this.i = HashArrayBackedSet.findIndexOfNextNonNull(this.table, 0);
                                if (this.i == -1) {
                                    this.table = null;
                                }
                            }
                        } else {
                            this.table = null;
                        }
                    }
                    return element;
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size];
            System.arraycopy(this.getFlatArray(), 0, result, 0, this.size);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            System.arraycopy(this.getFlatArray(), 0, result, 0, this.size);
            return result;
        }

        @Override
        public E any() {
            return this.getFlatArray()[0];
        }

        @Override
        public E only() {
            if (this.size() != 1) {
                throw new IllegalStateException();
            }
            return this.any();
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            int table1count = 0;
            int table2count = 0;
            E[] newTable1 = this.createTable1();
            E[] newTable2 = this.table2 != null ? this.createTable2() : null;
            E[] newFlat = this.createEArray(this.size);
            for (int i = 0; i < this.tableSize; ++i) {
                E v = this.table1[i];
                if (v == null || !predicate.test(v)) continue;
                newTable1[i] = v;
                newFlat[table1count] = v;
                ++table1count;
            }
            int count = table1count;
            if (this.table2 != null) {
                for (int i = 0; i < this.table2.length; ++i) {
                    int pos;
                    E v = this.table2[i];
                    if (v == null || !predicate.test(v)) continue;
                    int n = pos = i == 0 ? 0 : this.hashPosition(v);
                    if (newTable1[pos] == null) {
                        newTable1[pos] = v;
                        ++table1count;
                    } else {
                        int k = pos;
                        while (true) {
                            if (newTable2[k] == null) {
                                newTable2[k] = v;
                                ++table2count;
                                break;
                            }
                            ++k;
                        }
                    }
                    newFlat[count] = v;
                    ++count;
                }
            }
            if (count == 0) {
                return ImmutableSetImpl.empty();
            }
            if (count == 1) {
                return new OneElementSet<E>(newFlat[0]);
            }
            if (count == 2) {
                return new TwoElementSet<E>(newFlat[0], newFlat[1]);
            }
            if (count < this.size) {
                if (table2count == 0) {
                    return new HashArrayBackedSet<E>(this.tableSize, count, newTable1, null, newFlat);
                }
                return new HashArrayBackedSet<E>(this.tableSize, count, newTable1, newTable2, newFlat);
            }
            return this;
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            if (other.isEmpty()) {
                return ImmutableSetImpl.empty();
            }
            if (other == this) {
                return this;
            }
            if (other instanceof ImmutableSet && other.size() < this.size()) {
                return ((ImmutableSet)other).intersection(this);
            }
            if (other instanceof HashArrayBackedSet && ((HashArrayBackedSet)other).tableSize == this.tableSize) {
                return this.intersection((HashArrayBackedSet)other);
            }
            return this.matching(e -> other.contains(e));
        }

        @Override
        private ImmutableSet<E> intersection(HashArrayBackedSet<E> other) {
            int count;
            E v;
            int i;
            int table1count = 0;
            int table2count = 0;
            E[] newTable1 = this.createTable1();
            E[] newTable2 = this.table2 != null ? this.createTable2() : null;
            for (i = 0; i < this.tableSize; ++i) {
                v = this.table1[i];
                if (v == null || !other.contains(v, i)) continue;
                newTable1[i] = v;
                ++table1count;
            }
            if (this.table2 != null) {
                block1: for (i = 0; i < this.table2.length; ++i) {
                    int pos;
                    v = this.table2[i];
                    if (v == null) continue;
                    int n = pos = i == 0 ? 0 : this.hashPosition(v);
                    if (!other.contains(v, pos)) continue;
                    if (newTable1[pos] == null) {
                        newTable1[pos] = v;
                        ++table1count;
                        continue;
                    }
                    int k = pos;
                    while (true) {
                        if (newTable2[k] == null) {
                            newTable2[k] = v;
                            ++table2count;
                            continue block1;
                        }
                        ++k;
                    }
                }
            }
            if ((count = table1count + table2count) == 0) {
                return ImmutableSetImpl.empty();
            }
            if (count == 1) {
                return new OneElementSet<E>(HashArrayBackedSet.findFirstNonNull(newTable1, newTable2));
            }
            if (count < this.size) {
                if (table2count == 0) {
                    return new HashArrayBackedSet<E>(this.tableSize, count, newTable1, null);
                }
                return new HashArrayBackedSet<E>(this.tableSize, count, newTable1, newTable2);
            }
            return this;
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.isEmpty()) {
                return this;
            }
            return this.matching(e -> !other.contains(e));
        }

        @Override
        public String toShortString() {
            StringBuilder result = new StringBuilder("[");
            E[] flat = this.getFlatArray();
            for (int i = 0; i < flat.length; ++i) {
                if (i != 0) {
                    result.append(",");
                }
                result.append(flat[i]);
            }
            result.append("]");
            return result.toString();
        }

        @Override
        public ImmutableSet<E> with(E other) {
            int pos = this.hashPosition(other);
            if (this.table1[pos] != null) {
                if (other.equals(this.table1[pos])) {
                    return this;
                }
                if (this.table2 != null) {
                    if (this.table2[pos] != null) {
                        int check = this.checkTable2(other, pos);
                        if (check < 0) {
                            return this;
                        }
                        if (check == Integer.MAX_VALUE) {
                            return new WithSet<E>(this, other);
                        }
                        Object[] newTable2 = (Object[])this.table2.clone();
                        newTable2[check] = other;
                        return new HashArrayBackedSet<Object>(this.tableSize, this.size + 1, this.table1, newTable2);
                    }
                    Object[] newTable2 = (Object[])this.table2.clone();
                    newTable2[pos] = other;
                    return new HashArrayBackedSet<Object>(this.tableSize, this.size + 1, this.table1, newTable2);
                }
                E[] newTable2 = this.createTable2();
                newTable2[pos] = other;
                return new HashArrayBackedSet<E>(this.tableSize, this.size + 1, this.table1, newTable2);
            }
            Object[] newTable1 = (Object[])this.table1.clone();
            newTable1[pos] = other;
            return new HashArrayBackedSet<Object>(this.tableSize, this.size + 1, newTable1, this.table2);
        }

        @Override
        public ImmutableSet<E> with(ImmutableSet<E> other) {
            int otherSize = other.size();
            if (otherSize == 0) {
                return this;
            }
            if (otherSize == 1) {
                return this.with(other.only());
            }
            InternalBuilder builder = new Builder<E>(this);
            builder = builder.with(other);
            return builder.build();
        }

        @Override
        public ImmutableSet<E> with(E ... other) {
            int otherSize = other.length;
            if (otherSize == 0) {
                return this;
            }
            if (otherSize == 1) {
                return this.with(other[0]);
            }
            InternalBuilder builder = new Builder<E>(this);
            for (int i = 0; i < other.length; ++i) {
                builder = ((InternalBuilder)builder).with(other[i]);
            }
            return ((InternalBuilder)builder).build();
        }

        @Override
        public ImmutableSet<E> without(E other) {
            int pos = this.hashPosition(other);
            if (this.table1[pos] != null && other.equals(this.table1[pos])) {
                if (this.size == 1) {
                    return ImmutableSetImpl.empty();
                }
                Object[] newTable1 = (Object[])this.table1.clone();
                newTable1[pos] = null;
                if (this.table2 == null || this.table2[pos] == null) {
                    return new HashArrayBackedSet<Object>(this.tableSize, this.size - 1, newTable1, this.table2);
                }
                for (int i = pos; i < this.table2.length && this.table2[i] != null; ++i) {
                    int otherPos = this.hashPosition(this.table2[i]);
                    if (otherPos != pos) continue;
                    newTable1[pos] = this.table2[i];
                    Object[] newTable2 = (Object[])this.table2.clone();
                    newTable2[i] = null;
                    HashArrayBackedSet.repositionCollisions(this.tableSize, newTable2, i);
                    return new HashArrayBackedSet<Object>(this.tableSize, this.size - 1, newTable1, newTable2);
                }
                return new HashArrayBackedSet<Object>(this.tableSize, this.size - 1, newTable1, this.table2);
            }
            if (this.table2 != null && this.table2[pos] != null) {
                int check = this.checkTable2(other, pos);
                if (check < 0) {
                    if (this.size == 1) {
                        return ImmutableSetImpl.empty();
                    }
                    int actualPos = -check - 1;
                    Object[] newTable2 = (Object[])this.table2.clone();
                    newTable2[actualPos] = null;
                    HashArrayBackedSet.repositionCollisions(this.tableSize, newTable2, actualPos);
                    return new HashArrayBackedSet<Object>(this.tableSize, this.size - 1, this.table1, newTable2);
                }
                return this;
            }
            return this;
        }

        @Override
        public ImmutableList<E> toList() {
            return new ImmutableListImpl.ArrayBackedList<E>(this.getFlatArray());
        }

        private static <E> void repositionCollisions(int tableSize, E[] table2, int start) {
            assert (table2[start] == null);
            int firstGapAt = -1;
            int lastGapAt = -1;
            block0: for (int i = start + 1; i < table2.length; ++i) {
                if (table2[i] == null) {
                    return;
                }
                int pos = HashArrayBackedSet.hashPosition(tableSize, table2[i]);
                if (firstGapAt == -1) {
                    if (pos != i) {
                        table2[i - 1] = table2[i];
                        table2[i] = null;
                        continue;
                    }
                    firstGapAt = i - 1;
                    lastGapAt = i - 1;
                    continue;
                }
                if (pos == i) {
                    if (table2[i - 1] != null) continue;
                    lastGapAt = i - 1;
                    continue;
                }
                if (pos == lastGapAt) {
                    assert (table2[lastGapAt] == null);
                    table2[lastGapAt] = table2[i];
                    table2[i] = null;
                    lastGapAt = -1;
                    continue;
                }
                for (int k = i - 1; k >= firstGapAt && k >= pos; --k) {
                    if (table2[k] != null) continue;
                    table2[k] = table2[i];
                    table2[i] = null;
                    lastGapAt = -1;
                    continue block0;
                }
            }
        }

        E[] getFlatArray() {
            E v;
            int i;
            if (this.flat != null) {
                return this.flat;
            }
            E[] flat = this.createEArray(this.size);
            int k = 0;
            for (i = 0; i < this.table1.length; ++i) {
                v = this.table1[i];
                if (v == null) continue;
                flat[k] = v;
                ++k;
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    v = this.table2[i];
                    if (v == null) continue;
                    flat[k] = v;
                    ++k;
                }
            }
            this.flat = flat;
            return flat;
        }

        private E[] createTable1() {
            return new Object[this.tableSize];
        }

        private E[] createTable2() {
            return new Object[this.tableSize + 4];
        }

        private static <E> E[] createTable1(int tableSize) {
            return new Object[tableSize];
        }

        private static <E> E[] createTable2(int tableSize) {
            return new Object[tableSize + 4];
        }

        private E[] createEArray(int size) {
            return new Object[size];
        }

        static <E> E findFirstNonNull(E[] array) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                return array[i];
            }
            return null;
        }

        static <E> E findFirstNonNull(E[] array1, E[] array2) {
            E result = HashArrayBackedSet.findFirstNonNull(array1);
            if (result == null && array2 != null) {
                result = HashArrayBackedSet.findFirstNonNull(array2);
            }
            return result;
        }

        static int findIndexOfNextNonNull(Object[] array, int start) {
            for (int i = start; i < array.length; ++i) {
                if (array[i] == null) continue;
                return i;
            }
            return -1;
        }

        int hashPosition(Object e) {
            return HashArrayBackedSet.hashPosition(this.tableSize, e);
        }

        static int hashPosition(int tableSize, Object e) {
            if (e == null) {
                throw new IllegalArgumentException("ImmutableSet does not support null values");
            }
            int hash = e.hashCode();
            switch (tableSize) {
                case 16: {
                    return hash & 0xF ^ hash >> 4 & 0xF ^ hash >> 8 & 0xF ^ hash >> 12 & 0xF ^ hash >> 16 & 0xF ^ hash >> 20 & 0xF ^ hash >> 24 & 0xF ^ hash >> 28 & 0xF;
                }
                case 64: {
                    return hash & 0x3F ^ hash >> 6 & 0x3F ^ hash >> 12 & 0x3F ^ hash >> 18 & 0x3F ^ hash >> 24 & 0xF ^ hash >> 28 & 0xF;
                }
                case 256: {
                    return hash & 0xFF ^ hash >> 8 & 0xFF ^ hash >> 16 & 0xFF ^ hash >> 24 & 0xFF;
                }
            }
            throw new RuntimeException("Invalid tableSize " + tableSize);
        }

        int checkTable2(Object e, int hashPosition) {
            return HashArrayBackedSet.checkTable2(this.table2, e, hashPosition);
        }

        static <E> int checkTable2(E[] table2, Object e, int hashPosition) {
            if (table2[hashPosition] == null) {
                return hashPosition;
            }
            if (table2[hashPosition].equals(e)) {
                return -1 - hashPosition;
            }
            int max = hashPosition + 4;
            for (int i = hashPosition + 1; i <= max; ++i) {
                if (table2[i] == null) {
                    return i;
                }
                if (!table2[i].equals(e)) continue;
                return -1 - i;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            E v;
            int i;
            Object[] values1 = new Object[this.table1.length];
            Object[] values2 = this.table2 != null ? new Object[this.table2.length] : null;
            for (i = 0; i < this.tableSize; ++i) {
                v = this.table1[i];
                if (v == null) continue;
                values1[i] = mappingFunction.apply(v);
            }
            if (this.table2 != null) {
                for (i = 0; i < this.table2.length; ++i) {
                    v = this.table2[i];
                    if (v == null) continue;
                    values2[i] = mappingFunction.apply(v);
                }
            }
            return new ImmutableMapImpl.HashArrayBackedMap<E, Object>(this.tableSize, this.size, this.table1, values1, this.table2, values2);
        }

        static class Builder<E>
        extends InternalBuilder<E> {
            private static final Object T = new Object();
            private E[] table1;
            private E[] table2;
            private int size = 0;
            private final int tableSize;
            private boolean containsTombstones = false;
            private final E tombstone = T;

            public Builder(int tableSize) {
                this.tableSize = tableSize;
            }

            public Builder(HashArrayBackedSet<E> initialContent) {
                this.table1 = (Object[])((HashArrayBackedSet)initialContent).table1.clone();
                this.table2 = ((HashArrayBackedSet)initialContent).table2 != null ? (Object[])((HashArrayBackedSet)initialContent).table2.clone() : null;
                this.size = initialContent.size;
                this.tableSize = initialContent.tableSize;
            }

            @Override
            public InternalBuilder<E> with(E e) {
                if (e == null) {
                    throw new IllegalArgumentException("Null elements are not supported");
                }
                if (this.table1 == null) {
                    this.table1 = HashArrayBackedSet.createTable1(this.tableSize);
                    this.table1[this.hashPosition(e)] = e;
                    ++this.size;
                    return this;
                }
                int position = this.hashPosition(e);
                if (this.table1[position] == null) {
                    this.table1[position] = e;
                    ++this.size;
                    return this;
                }
                if (this.table1[position].equals(e)) {
                    return this;
                }
                if (this.table2 == null) {
                    this.table2 = HashArrayBackedSet.createTable2(this.tableSize);
                    this.table2[position] = e;
                    ++this.size;
                    return this;
                }
                if (this.table2[position] == null) {
                    this.table2[position] = e;
                    ++this.size;
                    return this;
                }
                int check = this.checkTable2(e, position);
                if (check < 0) {
                    return this;
                }
                if (check == Integer.MAX_VALUE) {
                    if (this.tableSize < 64) {
                        return new Builder<E>(64).with(this.build()).with(e);
                    }
                    if (this.tableSize < 256) {
                        return new Builder<E>(256).with(this.build()).with(e);
                    }
                    return new SetBackedSet.Builder<E>(this.build()).with((Object)e);
                }
                this.table2[check] = e;
                ++this.size;
                return this;
            }

            @Override
            InternalBuilder<E> with(Collection<E> collection) {
                InternalBuilder builder = this;
                for (E e : collection) {
                    builder = ((InternalBuilder)builder).with(e);
                }
                return builder;
            }

            @Override
            public ImmutableSet<E> build() {
                if (this.size == 0) {
                    return ImmutableSet.empty();
                }
                if (this.size == 1) {
                    E e = HashArrayBackedSet.findFirstNonNull(this.table1);
                    return new OneElementSet<E>(e);
                }
                if (this.size == 2) {
                    E e2;
                    int i1 = HashArrayBackedSet.findIndexOfNextNonNull(this.table1, 0);
                    E e1 = this.table1[i1];
                    int i2 = HashArrayBackedSet.findIndexOfNextNonNull(this.table1, i1 + 1);
                    if (i2 != -1) {
                        e2 = this.table1[i2];
                    } else {
                        i2 = this.findIndexOfNextNonNullNonTombstone(this.table2, 0);
                        e2 = this.table2[i2];
                    }
                    return new TwoElementSet<E>(e1, e2);
                }
                this.clearTombstones();
                return new HashArrayBackedSet<E>(this.tableSize, this.size, this.table1, this.table2);
            }

            private void clearTombstones() {
                if (!this.containsTombstones) {
                    return;
                }
                int max = this.tableSize + 4 - 1;
                int table2count = 0;
                block0: for (int i = 0; i <= max; ++i) {
                    if (this.table2[i] == this.tombstone) {
                        int kMax;
                        this.table2[i] = null;
                        for (int k = kMax = i >= this.tableSize ? max : i + 4; k > i; --k) {
                            if (this.table2[k] == null || this.table2[k] == this.tombstone || this.hashPosition(this.table2[k]) > i) continue;
                            this.table2[i] = this.table2[k];
                            this.table2[k] = this.tombstone;
                            continue block0;
                        }
                        continue;
                    }
                    if (this.table2[i] == null) continue;
                    ++table2count;
                }
                if (table2count == 0) {
                    this.table2 = null;
                }
            }

            @Override
            int size() {
                return this.size;
            }

            @Override
            boolean remove(E e) {
                int check;
                int position = this.hashPosition(e);
                if (this.table1[position] != null && this.table1[position].equals(e)) {
                    this.table1[position] = null;
                    --this.size;
                    if (this.table2 != null && this.table2[position] != null) {
                        this.table1[position] = this.pullElementWithHashPositionFromTable2(position);
                    }
                    return true;
                }
                if (this.table2 != null && this.table2[position] != null && (check = this.checkTable2(e, position)) < 0) {
                    int actualPos = -check - 1;
                    this.table2[actualPos] = this.tombstone;
                    this.containsTombstones = true;
                    --this.size;
                    return true;
                }
                return false;
            }

            @Override
            void clear() {
                this.size = 0;
                if (this.table1 != null) {
                    Arrays.fill(this.table1, null);
                }
                if (this.table2 != null) {
                    Arrays.fill(this.table2, null);
                }
            }

            @Override
            boolean contains(E e) {
                int position = this.hashPosition(e);
                if (this.table1 != null && this.table1[position] != null && this.table1[position].equals(e)) {
                    return true;
                }
                if (this.table2 != null && this.table2[position] != null) {
                    int check = this.checkTable2(e, position);
                    return check < 0;
                }
                return false;
            }

            @Override
            boolean containsAny(Set<E> set) {
                if (set instanceof HashArrayBackedSet && ((HashArrayBackedSet)set).tableSize == this.tableSize) {
                    return this.containsAny((HashArrayBackedSet)set);
                }
                for (E e : set) {
                    if (!this.contains(e)) continue;
                    return true;
                }
                return false;
            }

            @Override
            private boolean containsAny(HashArrayBackedSet<E> set) {
                for (int i = 0; i < this.tableSize; ++i) {
                    if (((HashArrayBackedSet)set).table1[i] != null && this.contains(((HashArrayBackedSet)set).table1[i], i)) {
                        return true;
                    }
                    if (((HashArrayBackedSet)set).table2 == null || ((HashArrayBackedSet)set).table2[i] == null || !this.contains(((HashArrayBackedSet)set).table2[i], i)) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean containsAll(Set<E> set) {
                if (set instanceof HashArrayBackedSet && ((HashArrayBackedSet)set).tableSize == this.tableSize) {
                    return this.containsAll((HashArrayBackedSet)set);
                }
                for (E e : set) {
                    if (this.contains(e)) continue;
                    return false;
                }
                return true;
            }

            @Override
            private boolean containsAll(HashArrayBackedSet<E> set) {
                for (int i = 0; i < this.tableSize; ++i) {
                    if (((HashArrayBackedSet)set).table1[i] != null && !this.contains(((HashArrayBackedSet)set).table1[i], i)) {
                        return false;
                    }
                    if (((HashArrayBackedSet)set).table2 == null || ((HashArrayBackedSet)set).table2[i] == null || this.contains(((HashArrayBackedSet)set).table2[i], i)) continue;
                    return false;
                }
                return true;
            }

            private boolean contains(Object e, int hashPosition) {
                if (this.table1 != null && this.table1[hashPosition] != null && this.table1[hashPosition].equals(e)) {
                    return true;
                }
                if (this.table2 != null && this.table2[hashPosition] != null) {
                    int check = this.checkTable2(e, hashPosition);
                    return check < 0;
                }
                return false;
            }

            @Override
            public Iterator<E> iterator() {
                if (this.size == 0) {
                    return Collections.emptyIterator();
                }
                return new Iterator<E>(){
                    int state = 0;
                    int nextState = 1;
                    int nextPos = 0;
                    int nextNextPos = 0;
                    E next;
                    E prev;
                    int prevState;
                    int prevPos;

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.initNext();
                        }
                        return this.next != null;
                    }

                    @Override
                    public E next() {
                        if (this.next != null) {
                            Object result = this.next;
                            this.prev = this.next;
                            this.prevState = this.state;
                            this.prevPos = this.nextPos;
                            this.next = null;
                            return result;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        if (this.prev == null) {
                            throw new NoSuchElementException();
                        }
                        if (this.prevState == 1) {
                            if (table1 != null && this.prev.equals(table1[this.prevPos])) {
                                ((Builder)this).table1[this.prevPos] = null;
                                size--;
                                if (table2 != null && table2[this.prevPos] != null) {
                                    ((Builder)this).table1[this.prevPos] = this.pullElementWithHashPositionFromTable2(this.prevPos);
                                    if (table1[this.prevPos] != null) {
                                        this.nextState = 1;
                                        this.nextNextPos = this.prevPos;
                                    }
                                }
                            }
                        } else if (this.prevState == 2 && table2 != null && this.prev.equals(table2[this.prevPos])) {
                            ((Builder)this).table2[this.prevPos] = tombstone;
                            containsTombstones = true;
                            size--;
                        }
                    }

                    private void initNext() {
                        int nextIndex;
                        if (this.nextState == 1) {
                            this.state = 1;
                            if (table1 != null) {
                                nextIndex = HashArrayBackedSet.findIndexOfNextNonNull(table1, this.nextNextPos);
                                if (nextIndex != -1) {
                                    this.nextPos = nextIndex;
                                    this.nextNextPos = nextIndex + 1;
                                    this.next = table1[nextIndex];
                                    return;
                                }
                                this.nextNextPos = 0;
                                this.nextState = 2;
                            } else {
                                this.nextState = 2;
                            }
                        }
                        if (this.nextState == 2) {
                            this.state = 2;
                            if (table2 != null) {
                                nextIndex = this.findIndexOfNextNonNullNonTombstone(table2, this.nextNextPos);
                                if (nextIndex != -1) {
                                    this.nextPos = nextIndex;
                                    this.nextNextPos = nextIndex + 1;
                                    this.next = table2[nextIndex];
                                    return;
                                }
                                this.nextNextPos = 0;
                                this.nextState = 2;
                            } else {
                                this.nextState = 3;
                            }
                        }
                        this.next = null;
                    }
                };
            }

            @Override
            E any() {
                return HashArrayBackedSet.findFirstNonNull(this.table1, this.table2);
            }

            private int hashPosition(Object e) {
                return HashArrayBackedSet.hashPosition(this.tableSize, e);
            }

            @Override
            String toDebugString() {
                return "size: " + this.size + "; tail1: " + (this.table1 != null ? Arrays.asList(this.table1).toString() : "null") + "; tail2: " + (this.table2 != null ? Arrays.asList(this.table2).toString() : "null");
            }

            int checkTable2(Object e, int hashPosition) {
                int insertionPositionCandidate = Integer.MAX_VALUE;
                if (this.table2[hashPosition] == null) {
                    return hashPosition;
                }
                if (this.table2[hashPosition] == this.tombstone) {
                    insertionPositionCandidate = hashPosition;
                } else if (this.table2[hashPosition].equals(e)) {
                    return -1 - hashPosition;
                }
                int max = hashPosition + 4;
                for (int i = hashPosition + 1; i <= max; ++i) {
                    if (this.table2[i] == null) {
                        if (insertionPositionCandidate != Integer.MAX_VALUE) {
                            return insertionPositionCandidate;
                        }
                        return i;
                    }
                    if (this.table2[i] == this.tombstone) {
                        if (insertionPositionCandidate != Integer.MAX_VALUE) continue;
                        insertionPositionCandidate = i;
                        continue;
                    }
                    if (!this.table2[i].equals(e)) continue;
                    return -1 - i;
                }
                return insertionPositionCandidate;
            }

            E pullElementWithHashPositionFromTable2(int hashPosition) {
                int max = hashPosition + 4;
                for (int i = hashPosition; i <= max; ++i) {
                    if (this.table2[i] == null) {
                        return null;
                    }
                    if (this.table2[i] == this.tombstone || this.hashPosition(this.table2[i]) != hashPosition) continue;
                    E result = this.table2[i];
                    this.table2[i] = this.tombstone;
                    this.containsTombstones = true;
                    return result;
                }
                return null;
            }

            int findIndexOfNextNonNullNonTombstone(Object[] array, int start) {
                for (int i = start; i < array.length; ++i) {
                    if (array[i] == null || array[i] == this.tombstone) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    static class ArrayBackedSet<E>
    extends AbstractImmutableSet<E> {
        private final E[] elements;
        private String cachedToShortString;

        ArrayBackedSet(E[] elements) {
            this.elements = elements;
        }

        ArrayBackedSet(Set<E> elements) {
            this.elements = elements.toArray();
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != null) continue;
                throw new IllegalArgumentException("ImmutableSet does not support null elements");
            }
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!this.elements[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.of(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, result, 0, this.elements.length);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= this.elements.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.elements.length);
            System.arraycopy(this.elements, 0, result, 0, this.elements.length);
            return result;
        }

        @Override
        public E any() {
            return this.elements[0];
        }

        @Override
        public E only() {
            if (this.size() != 1) {
                throw new IllegalStateException();
            }
            return this.elements[0];
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > this.elements.length) {
                return false;
            }
            for (Object other : c) {
                if (this.contains(other)) continue;
                return false;
            }
            return true;
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            E[] newElements = this.createEArray(this.elements.length);
            int k = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                E e = this.elements[i];
                if (!predicate.test(e)) continue;
                newElements[k] = e;
                ++k;
            }
            if (k == 0) {
                return ImmutableSetImpl.empty();
            }
            if (k == 1) {
                return new OneElementSet<E>(newElements[0]);
            }
            if (k == 2) {
                return new TwoElementSet<E>(newElements[0], newElements[1]);
            }
            if (k < this.elements.length) {
                E[] newElements2 = this.createEArray(k);
                System.arraycopy(newElements, 0, newElements2, 0, k);
                return new ArrayBackedSet<E>(newElements2);
            }
            return this;
        }

        @Override
        public Iterable<E> iterateMatching(final Predicate<E> predicate) {
            final int first = this.firstMatching(predicate);
            if (first == -1) {
                return ImmutableSetImpl.empty();
            }
            return new Iterable<E>(){

                @Override
                public Iterator<E> iterator() {
                    return new Iterator<E>(){
                        private int i;
                        {
                            this.i = first;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i < elements.length;
                        }

                        @Override
                        public E next() {
                            if (this.i >= elements.length) {
                                throw new NoSuchElementException();
                            }
                            Object element = elements[this.i];
                            ++this.i;
                            while (this.i < elements.length && !predicate.test(elements[this.i])) {
                                ++this.i;
                            }
                            return element;
                        }
                    };
                }
            };
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            if (other.isEmpty()) {
                return ImmutableSetImpl.empty();
            }
            if (other instanceof ImmutableSet && other.size() < this.size()) {
                return ((ImmutableSet)other).intersection(this);
            }
            E[] newElements = this.createEArray(this.elements.length);
            int k = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                E e = this.elements[i];
                if (!other.contains(e)) continue;
                newElements[k] = e;
                ++k;
            }
            if (k == 0) {
                return ImmutableSetImpl.empty();
            }
            if (k == 1) {
                return new OneElementSet<E>(newElements[0]);
            }
            if (k == 2) {
                return new TwoElementSet<E>(newElements[0], newElements[1]);
            }
            if (k < this.elements.length) {
                E[] newElements2 = this.createEArray(k);
                System.arraycopy(newElements, 0, newElements2, 0, k);
                return new ArrayBackedSet<E>(newElements2);
            }
            return this;
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.isEmpty()) {
                return this;
            }
            return this.matching(e -> !other.contains(e));
        }

        @Override
        public String toShortString() {
            if (this.cachedToShortString == null) {
                StringBuilder result = new StringBuilder("[");
                for (int i = 0; i < this.elements.length; ++i) {
                    if (i != 0) {
                        result.append(", ");
                    }
                    result.append(this.elements[i]);
                }
                result.append("]");
                this.cachedToShortString = result.toString();
            }
            return this.cachedToShortString;
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (predicate.test(this.elements[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return this.firstMatching(predicate) != -1;
        }

        private int firstMatching(Predicate<E> predicate) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!predicate.test(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        private E[] createEArray(int size) {
            return new Object[size];
        }

        @Override
        public ImmutableList<E> toList() {
            return new ImmutableListImpl.ArrayBackedList<E>(this.elements);
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            Object[] values = new Object[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                values[i] = mappingFunction.apply(this.elements[i]);
            }
            return new ImmutableMapImpl.ArrayBackedMap<E, Object>(this.elements, values);
        }
    }

    static class TwoElementSet<E>
    extends AbstractImmutableSet<E> {
        private final E e1;
        private final E e2;

        TwoElementSet(E e1, E e2) {
            this.e1 = e1;
            this.e2 = e2;
            if (e1.equals(e2)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public E any() {
            return this.e1;
        }

        @Override
        public E only() {
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o) || this.e2.equals(o);
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 2;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return e1;
                    }
                    if (this.i == 1) {
                        ++this.i;
                        return e2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1, this.e2};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 2 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
            result[0] = this.e1;
            result[1] = this.e2;
            return result;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > 2) {
                return false;
            }
            for (Object other : c) {
                if (this.e1.equals(other) || this.e2.equals(other)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.e1.hashCode() + this.e2.hashCode();
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            if (predicate.test(this.e1)) {
                if (predicate.test(this.e2)) {
                    return this;
                }
                return new OneElementSet<E>(this.e1);
            }
            if (predicate.test(this.e2)) {
                return new OneElementSet<E>(this.e2);
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public Iterable<E> iterateMatching(Predicate<E> predicate) {
            return this.matching(predicate);
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            if (other.contains(this.e1)) {
                if (other.contains(this.e2)) {
                    return this;
                }
                return new OneElementSet<E>(this.e1);
            }
            if (other.contains(this.e2)) {
                return new OneElementSet<E>(this.e2);
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.contains(this.e1)) {
                if (other.contains(this.e2)) {
                    return ImmutableSetImpl.empty();
                }
                return new OneElementSet<E>(this.e2);
            }
            if (other.contains(this.e2)) {
                return new OneElementSet<E>(this.e1);
            }
            return this;
        }

        @Override
        public String toString() {
            if (this.cachedToString == null) {
                this.cachedToString = "[" + this.e1 + ", " + this.e2 + "]";
            }
            return this.cachedToString;
        }

        @Override
        public String toShortString() {
            return this.toString();
        }

        @Override
        public ImmutableSet<E> without(E other) {
            if (this.e1.equals(other)) {
                return new OneElementSet<E>(this.e2);
            }
            if (this.e2.equals(other)) {
                return new OneElementSet<E>(this.e1);
            }
            return this;
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            return predicate.test(this.e1) && predicate.test(this.e2);
        }

        @Override
        public <O> ImmutableSet<O> map(Function<E, O> mappingFunction) {
            O o1 = mappingFunction.apply(this.e1);
            O o2 = mappingFunction.apply(this.e2);
            return ImmutableSetImpl.ofNonNull(o1, o2);
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return predicate.test(this.e1) || predicate.test(this.e2);
        }

        @Override
        public ImmutableList<E> toList() {
            return new ImmutableListImpl.TwoElementList<E>(this.e1, this.e2);
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            return ImmutableMap.of(this.e1, mappingFunction.apply(this.e1), this.e2, mappingFunction.apply(this.e2));
        }
    }

    static class OneElementSet<E>
    extends AbstractImmutableSet<E> {
        private final E e1;

        OneElementSet(E e1) {
            if (e1 == null) {
                throw new IllegalArgumentException("Null elements are not supported");
            }
            this.e1 = e1;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o);
        }

        @Override
        public E any() {
            return this.e1;
        }

        @Override
        public E only() {
            return this.e1;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.of(this.e1);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1};
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > 1) {
                return false;
            }
            for (Object other : c) {
                if (Objects.equals(this.e1, other)) continue;
                return false;
            }
            return true;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 1 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            result[0] = this.e1;
            return result;
        }

        @Override
        public int hashCode() {
            return this.e1.hashCode();
        }

        @Override
        public ImmutableSet<E> matching(Predicate<E> predicate) {
            if (predicate.test(this.e1)) {
                return this;
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public Iterable<E> iterateMatching(Predicate<E> predicate) {
            if (predicate.test(this.e1)) {
                return this;
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public ImmutableSet<E> intersection(Set<E> other) {
            if (other.contains(this.e1)) {
                return this;
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public ImmutableSet<E> without(Collection<E> other) {
            if (other.contains(this.e1)) {
                return ImmutableSetImpl.empty();
            }
            return this;
        }

        @Override
        public String toString() {
            if (this.cachedToString == null) {
                this.cachedToString = "[" + this.e1 + "]";
            }
            return this.cachedToString;
        }

        @Override
        public String toShortString() {
            return this.toString();
        }

        @Override
        public ImmutableSet<E> without(E other) {
            if (this.e1.equals(other)) {
                return ImmutableSetImpl.empty();
            }
            return this;
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            return predicate.test(this.e1);
        }

        @Override
        public <O> ImmutableSet<O> map(Function<E, O> mappingFunction) {
            O o = mappingFunction.apply(this.e1);
            if (o != null) {
                return new OneElementSet<O>(o);
            }
            return ImmutableSetImpl.empty();
        }

        @Override
        public <O> ImmutableSet<O> mapFlat(Function<E, Collection<O>> mappingFunction) {
            return ImmutableSet.of(mappingFunction.apply(this.e1));
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return predicate.test(this.e1);
        }

        @Override
        public ImmutableList<E> toList() {
            return new ImmutableListImpl.OneElementList<E>(this.e1);
        }

        @Override
        public <V> ImmutableMap<E, V> toMap(Function<E, V> mappingFunction) {
            return ImmutableMap.of(this.e1, mappingFunction.apply(this.e1));
        }
    }

    static abstract class InternalBuilder<E>
    implements Iterable<E> {
        InternalBuilder() {
        }

        abstract InternalBuilder<E> with(E var1);

        abstract InternalBuilder<E> with(Collection<E> var1);

        abstract boolean remove(E var1);

        abstract void clear();

        abstract boolean contains(E var1);

        abstract boolean containsAny(Set<E> var1);

        abstract boolean containsAll(Set<E> var1);

        abstract ImmutableSet<E> build();

        abstract int size();

        @Override
        public abstract Iterator<E> iterator();

        abstract E any();

        abstract String toDebugString();

        public String toString() {
            StringBuilder result = new StringBuilder("[");
            boolean first = true;
            for (E e : this) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(e);
            }
            result.append("]");
            result.append(" ").append(this.size()).append(this.getClass());
            return result.toString();
        }
    }

    static abstract class AbstractImmutableSet<E>
    extends AbstractImmutableCollection<E>
    implements ImmutableSet<E> {
        private int hashCode = -1;

        AbstractImmutableSet() {
        }

        @Override
        public ImmutableSet<E> with(E other) {
            int size = this.size();
            if (size == 0) {
                return new OneElementSet<E>(other);
            }
            if (size == 1) {
                Object onlyElement = this.only();
                if (other.equals(onlyElement)) {
                    return this;
                }
                return new TwoElementSet(onlyElement, other);
            }
            if (this.contains(other)) {
                return this;
            }
            return new ImmutableSet.Builder<E>(this).with(other).build();
        }

        @Override
        public ImmutableSet<E> with(Collection<E> other) {
            if (other instanceof ImmutableSet) {
                return this.with((ImmutableSet)other);
            }
            int size = this.size();
            int otherSize = other.size();
            if (size == 0) {
                return ImmutableSet.of(other);
            }
            if (otherSize == 0) {
                return this;
            }
            if (other.size() == 1) {
                return this.with(other.iterator().next());
            }
            if (size >= otherSize && this.containsAll(other)) {
                return this;
            }
            return new ImmutableSet.Builder<E>(this).with(other).build();
        }

        @Override
        public ImmutableSet<E> with(ImmutableSet<E> other) {
            int size = this.size();
            int otherSize = other.size();
            if (size == 0) {
                return other;
            }
            if (otherSize == 0) {
                return this;
            }
            if (size == 1) {
                return other.with(this.only());
            }
            if (other.size() == 1) {
                return this.with(other.only());
            }
            if (size >= otherSize) {
                if (this.containsAll(other)) {
                    return this;
                }
            } else if (other.containsAll(this)) {
                return other;
            }
            return new ImmutableSet.Builder(this).with(other).build();
        }

        @Override
        public ImmutableSet<E> with(E ... other) {
            if (other == null || other.length == 0) {
                return this;
            }
            int size = this.size();
            int otherSize = other.length;
            if (size == 0) {
                return ImmutableSet.ofArray(other);
            }
            if (otherSize == 1) {
                return this.with(other[0]);
            }
            return new ImmutableSet.Builder<E>(this).with(Arrays.asList(other)).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Set) {
                Set otherSet = (Set)o;
                return otherSet.size() == this.size() && this.containsAll(otherSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                int newHashCode = 0;
                for (Object e : this) {
                    newHashCode += e.hashCode();
                }
                this.hashCode = newHashCode;
            }
            return this.hashCode;
        }

        @Override
        public ImmutableSet<E> without(E other) {
            if (this.contains(other)) {
                return this.matching(e -> !e.equals(other));
            }
            return this;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > this.size()) {
                return false;
            }
            for (Object other : c) {
                if (this.contains(other)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            for (Object e : this) {
                if (predicate.test(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            for (Object e : this) {
                if (!predicate.test(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <O> ImmutableSet<O> map(Function<E, O> mappingFunction) {
            ImmutableSet.Builder<O> builder = new ImmutableSet.Builder<O>(this.size());
            for (Object e : this) {
                O o = mappingFunction.apply(e);
                if (o == null) continue;
                builder.with(o);
            }
            return builder.build();
        }

        @Override
        public <O> ImmutableSet<O> mapFlat(Function<E, Collection<O>> mappingFunction) {
            ImmutableSet.Builder<O> builder = new ImmutableSet.Builder<O>(this.size());
            for (Object e : this) {
                Collection<O> o = mappingFunction.apply(e);
                if (o == null) continue;
                builder.with(o);
            }
            return builder.build();
        }

        @Override
        public boolean containsAny(Collection<E> collection) {
            for (E e : collection) {
                if (!this.contains(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterable<E> iterateMatching(Predicate<E> predicate) {
            return IterableView.filter(this, predicate);
        }
    }
}

